function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = NK_financial.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(51, 93);
g1(1,20)=(-T(4));
g1(1,59)=1;
g1(1,86)=(-T(6));
g1(2,18)=1;
g1(2,69)=(-T(6));
g1(2,20)=(-1);
g1(3,19)=1;
g1(3,70)=(-T(6));
g1(3,20)=(-1);
g1(3,35)=params(28)*2*(y(35)-(steady_state(18)));
g1(4,20)=1;
g1(4,1)=(-(T(9)*T(50)*T(51)/(1-params(6))));
g1(4,21)=(-(T(9)*T(51)/(1-params(6))));
g1(4,22)=(-(T(8)*T(56)));
g1(5,2)=(-((1-params(3))/(1+T(1))));
g1(5,23)=1;
g1(5,24)=(-(y(27)*(-y(26))));
g1(5,26)=(-((1-y(24))*y(27)));
g1(5,27)=(-((1-y(24))*y(26)));
g1(6,25)=1;
g1(6,3)=(-((-((1+T(1))*y(26)))/(y(3)*y(3))));
g1(6,26)=(-((1+T(1))/y(3)));
g1(7,24)=1;
g1(7,25)=(-(params(8)*2*(y(25)-1-T(1))));
g1(8,25)=(-(2*params(8)));
g1(8,28)=1;
g1(9,20)=(-((1-params(6))/T(7)));
g1(9,71)=T(49)/((1+T(1))*y(72)-y(21)*params(7));
g1(9,1)=(-((-((1-params(6))*y(20)*T(50)))/(T(7)*T(7))));
g1(9,21)=(-((-((1-params(6))*y(20)))/(T(7)*T(7))-(-(T(10)*(-params(7))))/T(53)));
g1(9,72)=(-((1+T(1))*T(10)))/T(53);
g1(9,29)=1;
g1(10,29)=(-(y(68)/(y(29)*y(29))));
g1(10,30)=1;
g1(10,68)=(-((-1)/y(29)));
g1(11,29)=(-(y(32)*y(78)*T(62)));
g1(11,76)=(-(y(32)*y(78)*T(63)));
g1(11,32)=(-(y(78)*T(3)));
g1(11,78)=(-(y(32)*T(3)));
g1(12,29)=(-((y(77)+(1-params(3))*y(79))*T(62)));
g1(12,76)=(-((y(77)+(1-params(3))*y(79))*T(63)));
g1(12,77)=(-T(3));
g1(12,34)=1;
g1(12,79)=(-((1-params(3))*T(3)));
g1(13,24)=(-(y(27)*(-y(34))));
g1(13,25)=(-(y(27)*y(34)*(-y(28))));
g1(13,73)=(-(y(74)*T(3)*y(79)*y(75)*2*y(73)));
g1(13,27)=(-(y(34)*(1-y(24)-y(25)*y(28))));
g1(13,74)=(-T(12));
g1(13,28)=(-(y(27)*y(34)*(-y(25))));
g1(13,75)=(-(y(74)*T(3)*y(79)*T(11)));
g1(13,29)=(-(y(74)*T(11)*y(75)*y(79)*T(62)));
g1(13,76)=(-(y(74)*T(11)*y(75)*y(79)*T(63)));
g1(13,34)=(-(y(27)*(1-y(24)-y(25)*y(28))));
g1(13,79)=(-(y(74)*T(11)*T(3)*y(75)));
g1(14,33)=1;
g1(14,7)=(-(1/y(36)));
g1(14,36)=(-((-y(7))/(y(36)*y(36))));
g1(15,20)=(-((-(1-params(6)))*T(13)));
g1(15,22)=(-(y(20)*(-(1-params(6)))*T(57)));
g1(15,68)=1;
g1(16,36)=(-((1+T(1))*y(38)/y(9)));
g1(16,37)=1;
g1(16,9)=(-(y(36)*(-((1+T(1))*y(38)))/(y(9)*y(9))));
g1(16,38)=(-(y(36)*(1+T(1))/y(9)));
g1(17,29)=(-(y(82)*T(17)*(1+T(1))*params(10)*T(62)));
g1(17,76)=(-(y(82)*T(17)*(1+T(1))*params(10)*T(63)));
g1(17,30)=(-(y(41)*T(14)*y(40)));
g1(17,36)=(-(y(82)*T(3)*(1+T(1))*params(10)*T(77)));
g1(17,81)=(-(y(82)*T(3)*(1+T(1))*params(10)*T(95)/T(16)));
g1(17,39)=1;
g1(17,82)=(-(T(3)*(1+T(1))*params(10)*T(17)));
g1(17,40)=(-(y(30)*T(14)*y(41)));
g1(17,41)=(-(y(30)*T(14)*y(40)));
g1(18,29)=(-(y(83)*T(20)*params(10)*T(62)));
g1(18,76)=(-(y(83)*T(20)*params(10)*T(63)));
g1(18,36)=(-(y(83)*T(3)*params(10)*T(81)));
g1(18,80)=(-(y(83)*T(3)*params(10)*T(89)));
g1(18,81)=(-(y(83)*T(3)*params(10)*T(95)/T(19)));
g1(18,40)=(-1);
g1(18,42)=1;
g1(18,83)=(-(T(3)*params(10)*T(20)));
g1(19,38)=(-((-(y(39)*y(42)))/(y(38)*y(42)*y(38)*y(42))));
g1(19,39)=(-(1/(y(38)*y(42))));
g1(19,42)=(-((-(y(38)*y(39)))/(y(38)*y(42)*y(38)*y(42))));
g1(19,43)=1;
g1(20,8)=(-(params(10)*T(66)*T(67)));
g1(20,37)=(-(params(10)*T(67)*(-T(21))/(y(37)*y(37))));
g1(20,43)=(-((1-params(10))*getPowerDeriv(y(43),1-params(5),1)));
g1(21,8)=(-(y(11)*params(10)*T(69)/(T(24)*T(24))));
g1(21,37)=(-(y(11)*params(10)*T(94)/T(24)));
g1(21,43)=(-((1-params(10))*getPowerDeriv(y(43),(-params(5)),1)));
g1(21,11)=(-(params(10)*T(23)/T(24)));
g1(21,44)=1;
g1(22,2)=(-(T(25)*T(59)));
g1(22,40)=(-(T(27)*y(46)*T(98)));
g1(22,45)=1;
g1(22,46)=(-(T(27)*y(40)*T(98)));
g1(23,38)=1;
g1(23,40)=(-((-(y(45)*params(2)*y(47)))/(y(40)*y(40))));
g1(23,45)=(-(params(2)*y(47)/y(40)));
g1(23,47)=(-(y(45)*params(2)/y(40)));
g1(24,2)=(-((-(y(45)*(1-params(2))*y(47)*T(58)))/(T(26)*T(26))));
g1(24,31)=1;
g1(24,45)=(-((1-params(2))*y(47)/T(26)));
g1(24,47)=(-(y(45)*(1-params(2))/T(26)));
g1(25,47)=(-1);
g1(25,48)=1;
g1(26,29)=(-(y(84)*T(32)*(1+T(1))*params(9)*T(62)));
g1(26,76)=(-(y(84)*T(32)*(1+T(1))*params(9)*T(63)));
g1(26,36)=(-(y(84)*T(3)*(1+T(1))*params(9)*T(84)));
g1(26,80)=(-(y(84)*T(3)*(1+T(1))*params(9)*T(91)));
g1(26,48)=(-(T(29)*y(51)));
g1(26,49)=1;
g1(26,84)=(-(T(3)*(1+T(1))*params(9)*T(32)));
g1(26,50)=(-(y(51)*y(48)*T(28)));
g1(26,51)=(-(y(48)*T(29)));
g1(27,29)=(-(y(85)*T(35)*(1+T(1))*params(9)*T(62)));
g1(27,76)=(-(y(85)*T(35)*(1+T(1))*params(9)*T(63)));
g1(27,36)=(-(y(85)*T(3)*(1+T(1))*params(9)*T(87)));
g1(27,80)=(-(y(85)*T(3)*(1+T(1))*params(9)*T(93)));
g1(27,50)=(-1);
g1(27,52)=1;
g1(27,85)=(-(T(3)*(1+T(1))*params(9)*T(35)));
g1(28,49)=(-(1/y(52)));
g1(28,52)=(-((-y(49))/(y(52)*y(52))));
g1(28,53)=1;
g1(29,8)=(-(params(9)*T(71)*T(72)));
g1(29,36)=(-(params(9)*T(72)*(-T(36))/(y(36)*y(36))));
g1(29,53)=(-((1-params(9))*getPowerDeriv(y(53),1-params(4),1)));
g1(30,8)=(-(y(15)*params(9)*T(74)/(T(39)*T(39))));
g1(30,36)=(-(y(15)*params(9)*T(88)/T(39)));
g1(30,53)=(-((1-params(9))*getPowerDeriv(y(53),(-params(4)),1)));
g1(30,15)=(-(params(9)*T(38)/T(39)));
g1(30,54)=1;
g1(31,7)=(-(params(16)*T(64)/T(41)));
g1(31,35)=T(64)/T(40);
g1(31,36)=(-((1-params(16))*params(17)*1/(steady_state(19))/T(42)));
g1(31,13)=(-((1-params(16))*params(19)*T(99)/T(44)));
g1(31,50)=(-((1-params(16))*(params(18)*1/(steady_state(33))/T(43)+params(19)*T(100)/T(44))));
g1(31,55)=(-(1/y(55)));
g1(32,21)=(-1);
g1(32,26)=(-1);
g1(32,50)=1;
g1(32,56)=(-1);
g1(33,22)=1;
g1(33,40)=(-y(44));
g1(33,44)=(-y(40));
g1(34,45)=1;
g1(34,50)=(-y(54));
g1(34,54)=(-y(50));
g1(35,31)=(-(1/y(6)));
g1(35,6)=(-((-(y(31)+(1-params(3))*y(34)))/(y(6)*y(6))));
g1(35,34)=(-((1-params(3))/y(6)));
g1(35,57)=1;
g1(36,33)=1;
g1(36,57)=(-1);
g1(36,58)=1;
g1(37,12)=(-(params(20)*1/y(12)));
g1(37,46)=1/y(46);
g1(37,87)=(-1);
g1(38,17)=(-(params(21)*1/y(17)));
g1(38,56)=1/y(56);
g1(38,88)=(-1);
g1(39,14)=(-(params(22)*1/y(14)));
g1(39,51)=1/y(51);
g1(39,89)=(-1);
g1(40,10)=(-(params(23)*1/y(10)));
g1(40,41)=1/y(41);
g1(40,92)=(-1);
g1(41,4)=(-(params(26)*1/y(4)));
g1(41,27)=1/y(27);
g1(41,91)=(-1);
g1(42,16)=(-(params(24)*1/y(16)));
g1(42,55)=1/y(55);
g1(42,90)=(-1);
g1(43,5)=(-(params(25)*1/y(5)));
g1(43,32)=1/y(32);
g1(43,93)=(-1);
g1(44,13)=(-((1+T(1))*T(99)/((1+T(1))*T(44))));
g1(44,50)=(-((1+T(1))*T(100)/((1+T(1))*T(44))));
g1(44,60)=1;
g1(45,1)=(-(T(52)/T(45)));
g1(45,21)=(-(T(54)/T(45)));
g1(45,61)=1;
g1(46,3)=(-(T(60)/T(46)));
g1(46,26)=(-(T(61)/T(46)));
g1(46,66)=1;
g1(47,9)=(-(T(96)/T(47)));
g1(47,38)=(-(T(97)/T(47)));
g1(47,67)=1;
g1(48,40)=(-(1/(steady_state(23))));
g1(48,64)=1;
g1(49,35)=(-1);
g1(49,63)=1;
g1(50,36)=(-(1/y(36)));
g1(50,62)=1;
g1(51,58)=(-1);
g1(51,65)=1;

end
